package gov.va.genisis2.dto;

import java.io.Serializable;
import java.util.Date;
import java.util.Set;

import javax.xml.bind.annotation.XmlRootElement;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;

/**
 * Data Transfer Object (DTO) to transfer request related details
 * 
 * @author Prasad Thummalapalli
 *
 */
@XmlRootElement(name = "request")
@JsonInclude(Include.NON_NULL)
@JsonIgnoreProperties({ "processId", "taskId", "requestType", "studyApproval", "source", "requestHistories" })
public class RequestDTO implements Serializable {

	private static final long serialVersionUID = -5493342099044590909L;

	private int id;
	private int processId;
	private String title;
	private String description;
	private String statusDescription;
	private Date createdOn;
	private Date modifiedOn;
	private String createdBy;
	private String modifiedBy;
	private String approverId;
	private String taskId;
	private String comments;
	private Set<RequestHistoryDTO> requestHistories;
	private int requestTypeId;
	private RequestTypeDTO requestType;
	private int studyApprovalId;
	private StudyApprovalDTO studyApproval;
	private int sourceId;
	private SourceDTO source;

	/**
	 * @return the id
	 */
	public int getId() {
		return id;
	}

	/**
	 * @param id
	 *            the id to set
	 */
	public void setId(int id) {
		this.id = id;
	}

	/**
	 * @return the processId
	 */
	public int getProcessId() {
		return processId;
	}

	/**
	 * @param processId
	 *            the processId to set
	 */
	public void setProcessId(int processId) {
		this.processId = processId;
	}

	/**
	 * @return the title
	 */
	public String getTitle() {
		return title;
	}

	/**
	 * @param title
	 *            the title to set
	 */
	public void setTitle(String title) {
		this.title = title;
	}

	/**
	 * @return the description
	 */
	public String getDescription() {
		return description;
	}

	/**
	 * @param description
	 *            the description to set
	 */
	public void setDescription(String description) {
		this.description = description;
	}

	/**
	 * @return the statusDescription
	 */
	public String getStatusDescription() {
		return statusDescription;
	}

	/**
	 * @param statusDescription
	 *            the statusDescription to set
	 */
	public void setStatusDescription(String statusDescription) {
		this.statusDescription = statusDescription;
	}

	/**
	 * @return the createdOn
	 */
	public Date getCreatedOn() {
		return createdOn;
	}

	/**
	 * @param createdOn
	 *            the createdOn to set
	 */
	public void setCreatedOn(Date createdOn) {
		this.createdOn = createdOn;
	}

	/**
	 * @return the modifiedOn
	 */
	public Date getModifiedOn() {
		return modifiedOn;
	}

	/**
	 * @param modifiedOn
	 *            the modifiedOn to set
	 */
	public void setModifiedOn(Date modifiedOn) {
		this.modifiedOn = modifiedOn;
	}

	/**
	 * @return the createdBy
	 */
	public String getCreatedBy() {
		return createdBy;
	}

	/**
	 * @param createdBy
	 *            the createdBy to set
	 */
	public void setCreatedBy(String createdBy) {
		this.createdBy = createdBy;
	}

	/**
	 * @return the modifiedBy
	 */
	public String getModifiedBy() {
		return modifiedBy;
	}

	/**
	 * @param modifiedBy
	 *            the modifiedBy to set
	 */
	public void setModifiedBy(String modifiedBy) {
		this.modifiedBy = modifiedBy;
	}

	/**
	 * @return the approverId
	 */
	public String getApproverId() {
		return approverId;
	}

	/**
	 * @param approverId
	 *            the approverId to set
	 */
	public void setApproverId(String approverId) {
		this.approverId = approverId;
	}

	/**
	 * @return the taskId
	 */
	public String getTaskId() {
		return taskId;
	}

	/**
	 * @param taskId
	 *            the taskId to set
	 */
	public void setTaskId(String taskId) {
		this.taskId = taskId;
	}

	/**
	 * @return the comments
	 */
	public String getComments() {
		return comments;
	}

	/**
	 * @param comments
	 *            the comments to set
	 */
	public void setComments(String comments) {
		this.comments = comments;
	}

	/**
	 * @return the requestHistories
	 */
	public Set<RequestHistoryDTO> getRequestHistories() {
		return requestHistories;
	}

	/**
	 * @param requestHistories
	 *            the requestHistories to set
	 */
	public void setRequestHistories(Set<RequestHistoryDTO> requestHistories) {
		this.requestHistories = requestHistories;
	}

	/**
	 * @return the requestTypeId
	 */
	public int getRequestTypeId() {
		return requestTypeId;
	}

	/**
	 * @param requestTypeId
	 *            the requestTypeId to set
	 */
	public void setRequestTypeId(int requestTypeId) {
		this.requestTypeId = requestTypeId;
	}

	/**
	 * @return the requestType
	 */
	public RequestTypeDTO getRequestType() {
		return requestType;
	}

	/**
	 * @param requestType
	 *            the requestType to set
	 */
	public void setRequestType(RequestTypeDTO requestType) {
		this.requestType = requestType;
	}

	/**
	 * @return the studyApprovalId
	 */
	public int getStudyApprovalId() {
		return studyApprovalId;
	}

	/**
	 * @param studyApprovalId
	 *            the studyApprovalId to set
	 */
	public void setStudyApprovalId(int studyApprovalId) {
		this.studyApprovalId = studyApprovalId;
	}

	/**
	 * @return the studyApproval
	 */
	public StudyApprovalDTO getStudyApproval() {
		return studyApproval;
	}

	/**
	 * @param studyApproval
	 *            the studyApproval to set
	 */
	public void setStudyApproval(StudyApprovalDTO studyApproval) {
		this.studyApproval = studyApproval;
	}

	/**
	 * @return the sourceId
	 */
	public int getSourceId() {
		return sourceId;
	}

	/**
	 * @param sourceId
	 *            the sourceId to set
	 */
	public void setSourceId(int sourceId) {
		this.sourceId = sourceId;
	}

	/**
	 * @return the source
	 */
	public SourceDTO getSource() {
		return source;
	}

	/**
	 * @param source
	 *            the source to set
	 */
	public void setSource(SourceDTO source) {
		this.source = source;
	}
}
